 ; Ŀ
 ;   Blur - block replacer.                                                
 ;   Copyright 1994, 2006, 2007 by Rocket Software Ltd.                    
 ;   Named for the speed at which it operates, not the state of your       
 ;   vision after eight hours in front of a monitor.                       
 ; 

 ; Ŀ
 ;   Subroutine Gnam - Get a block name by input or selection.             
 ; 
 (DEFUN GNAM (str / blnam typp)
  (setq blnam (getstring (strcat str " or <Return> to pick: ")))
  (if (= blnam "")
      (progn
           (setq blnam (entsel "Select block: "))
           (if blnam (setq typp (cdr (assoc 0 (entget (car blnam))))))
           (if (= typp "INSERT")
               (progn
                    (setq blnam (cdr (assoc 2 (entget (car blnam)))))
                    (prompt blnam))
               (setq blnam ()))))
 blnam)
 ; Ŀ
 ;   Gnam end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Prdett - search a block definition for attribute defaults. 
 ; 
 (DEFUN PRDETT (new / blok namm entt pr isdef)
  (setq blok (tblsearch "block" new))    ; get head entity
  (setq namm (cdr (assoc -2 blok)))      ; first ename after head
  (while (and namm (null isdef))        ; while there is an entity
        (setq entt (entget namm))        ; the whole thing
        (if (and (setq pr (assoc 1 entt)) (/= (cdr pr) ""))
            (setq isdef T))
        (setq namm (entnext namm)))      ; next subentity ename
 isdef)
 ; Ŀ
 ;   Prdett end.                                                           
 ; 

 ; Ŀ
 ;   Blur - the bullet.                                                    
 ; 
 (DEFUN C:BLUR (/ *error* old typp ss new isnew blcfil insp isdef usedef how
                  esav enam entt scla pa rota xsc ysc zsc layy main sub tagg
                                                                      cc num)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq atrq (getvar "attreq"))
  (setvar "attreq" 0)
  (setq limch (getvar "limcheck"))
  (setvar "limcheck" 0)
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "attreq" atrq)
   (setvar "limcheck" limch)
   (setvar "osmode" osm)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get the existing and replacement block names.  See if both exist.     
 ; 
  (setq old (gnam "Block to replace"))
  (cond ((null old)
         (write-line "\nThat wasn't a block."))
        ((null (tblsearch "block" old))
         (write-line (strcat "Block " old " isn't inserted in this drawing.")))
        ((null (setq ss (ssget "X" (list (cons 2 old)))))
         (write-line (strcat "Can't find any insertions of " old ".")))
        ((null (setq new (gnam "\nNew block")))
         (write-line "\nThat wasn't a block.")
         (setq ss ()))
        ((and (null (setq isnew (tblsearch "block" new)))
              (setq blcfil (findfile (strcat new ".dwg"))))
         (write-line (strcat "Block " new " is not defined in this drawing."))
         (initget 0 "Yes No")
         (Setq insp (getkword (strcat "Do you wish to use " blcfil " <Y>?")))
         (if (or (null insp) (= insp "Yes"))
             (progn
                  (command "insert" re )
                  (command))
             (setq ss ())))
        ((null isnew)
         (write-line (strcat new " is not available in this drawing."))
         (setq ss ())))
 ; Ŀ
 ;   At this point if ss exists then we have two block names, both are     
 ;   present and there are some of the original ones ready to replace.     
 ; 
  (if ss
     (progn
 ; Ŀ
 ;   Check for default attribute values, if any are found ask whether to   
 ;   use them in the absence of a value.                                   
 ; 
          (setq isdef (prdett new))
          (if isdef
              (progn
                   (initget 0 "Yes No")
                   (write-line (strcat "The block definition for " new
                                       " contains default attribute values."))
                   (setq usedef (getkword
               "Use them in the absence of a replacement value? Yes/<No>: "))))
          (if (= usedef "No") (setq usedef ()))
 ; Ŀ
 ;   Now see exactly what is to be done with the inserts.                  
 ; 
          (if usedef
              (progn
                  (initget 0 "Attribute Tag Order Ignore Defaults Only")
                (setq how (getkword (strcat "\nReplace text by <Attribute tag>"
                    "/in Order/in order Ignore empties/use Defaults only: "))))
              (progn
                  (initget 0 "Attribute Tag Order Ignore Leave Empty")
                (setq how (getkword (strcat "\nReplace text by <Attribute tag>"
                         "/in Order/in order Ignore empties/leave Empty: ")))))
          (if (null how) (setq how "Attribute"))
 ; Ŀ
 ;   Ask at what scale the new blocks should be inserted.                  
 ; 
          (setq scla (getreal "Block insertion scale (<Return> = current): "))
 ; Ŀ
 ;   The selection set processor loop.                                     
 ; 
          (setq num 0)
          (while (setq esav (setq enam (ssname ss 0)))
                 (setq num (1+ num))
                 (ssdel esav ss)
                 (setq entt (entget enam))
 ; Ŀ
 ;   Find the block insertion, X, Y, and Z scales, rotation and layer.     
 ; 
                 (setq pa (cdr (assoc 10 entt)))
                 (setq rota (cdr (assoc 50 entt)))
                 (if rota
                    (setq rota (/ (* 180 rota) pi))
                    (setq rota 0))
                 (if scla
                    (progn
                         (setq xsc scla)
                         (setq ysc scla)
                         (setq zsc scla))
                    (progn
                         (setq xsc (cdr (assoc 41 entt)))
                         (if (null xsc) (setq xsc 1))
                         (setq ysc (cdr (assoc 42 entt)))
                         (if (null ysc) (setq ysc 1))
                         (setq zsc (cdr (assoc 43 entt)))
                         (if (null zsc) (setq zsc 1))))
                 (setq layy (assoc 8 entt))
 ; Ŀ
 ;   Step through the block and get attribute tags and values.             
 ;   (if there are attributes - the 66 sublist is present.)                
 ; 
                 (setq main ())
                 (if (assoc 66 (entget enam))
                     (while (and (setq enam (entnext enam))
                                 (/= (cdr (assoc 0 (setq entt (entget enam))))
                                                                     "SEQEND"))
                            (setq sub (list (assoc 2 entt) (assoc 1 entt)))
                            (setq main (append main (list sub)))))
 ; Ŀ
 ;   Now erase the old new block and insert the new one.                   
 ; 
                 (entdel esav)
                 (command "insert" new pa "xyz" xsc ysc zsc rota)
                 (setq esav (setq enam (entlast)))
 ; Ŀ
 ;   And reapply the attribute values depending on the value of How.       
 ; 
                 (cond ((or (= how "Attribute") (= how "Tag"))
                        (while (and (setq enam (entnext enam))
                                    (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                               (setq tagg (assoc 2 entt))
                               (if (setq cc (assoc tagg main))
                                   (entmod (subst (cadr cc)
                                                  (assoc 1 entt) entt))
                                   (if (null usedef)
                                       (entmod (subst (cons 1 "")
                                                      (assoc 1 entt) entt))))))
                       ((= how "Order")
                        (while (and (setq enam (entnext enam))
                                    (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                               (setq cc (cadar main))
                               (setq main (cdr main))
                               (if cc
                                  (entmod (subst cc (assoc 1 entt) entt))
                                  (if (null usedef)
                                      (entmod (subst (cons 1 "")
                                                     (assoc 1 entt) entt))))))
                       ((= how "Ignore")
                        (while (and (setq enam (entnext enam))
                                    (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                               (setq cc (cadar main))
                               (setq main (cdr main))
                               (while (or (= (cdr cc) "") (= (cdr cc) " "))
                                      (setq cc (cadar main))
                                      (setq main (cdr main)))
                               (if cc
                                  (entmod (subst cc (assoc 1 entt) entt))
                                  (if (null usedef)
                                      (entmod (subst (cons 1 "")
                                                     (assoc 1 entt) entt))))))
                       ((or (= how "Leave") (= how "Empty"))
                        (while (and (setq enam (entnext enam))
                                    (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                                     (entmod (subst (cons 1 "")
                                                     (assoc 1 entt) entt))))
                       ((or (= how "Defaults") (= how "Only"))))
 ; Ŀ
 ;   Put the block on the correct layer.                                   
 ; 
                 (setq entt (entget esav))
                 (entmod (subst layy (assoc 8 entt) entt))
                 )))               ; while end, ifend, progend
 ; Ŀ
 ;   Report.                                                               
 ; 
  (if num (write-line (strcat (itoa num) " block"
                              (if (= num 1) "" "s") " replaced.")))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (*error* ())
 (princ))